---
generated_at: 2026-02-02 10:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：71-Pod Admission制御

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **Kubelet SyncLoopからの呼び出しフロー**：直接的なコード確認が必要

## 2) 参照した情報（Evidence一覧）
- E-01: `pkg/kubelet/lifecycle/interfaces.go` - PodAdmitHandler, PodAdmitAttributes, PodAdmitResult定義
- E-02: `pkg/kubelet/lifecycle/predicate.go` - predicateAdmitHandler実装
- E-03: `pkg/kubelet/lifecycle/handlers.go` - AppArmor/PodFeatures/DeclaredFeaturesハンドラー
- E-04: `pkg/kubelet/lifecycle/admission_failure_handler_stub.go` - スタブ実装
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PodAdmitHandlerインターフェースは複数のハンドラーをチェーン実行する | E-01 (101-106行目) | ○ |
| C-02 | predicateAdmitHandlerがリソース充足を判定する | E-02 (119-250行目) | ○ |
| C-03 | OS互換性チェック（OSSelector）が行われる | E-02 (280-297行目) | ○ |
| C-04 | OS互換性チェック（OSField）が行われる | E-02 (302-308行目) | ○ |
| C-05 | SupplementalGroupsPolicyのチェックが行われる | E-02 (316-347行目) | ○ |
| C-06 | generalFilterがスケジューラーのAdmissionCheckを再利用する | E-02 (435-436行目) | ○ |
| C-07 | 静的PodはTaintチェックが免除される | E-02 (452行目) | ○ |
| C-08 | AppArmorAdmitHandlerがPendingフェーズのみ検証する | E-03 (200-215行目) | ○ |
| C-09 | podFeaturesAdmitHandlerがPodLevelResourcesをチェックする | E-03 (236-238行目) | ○ |
| C-10 | declaredFeaturesAdmitHandlerがノードフィーチャーをマッチングする | E-03 (257-292行目) | ○ |
| C-11 | NodeAffinityによる拒否時にキャッシュなしで再取得する | E-02 (253-276行目) | ○ |
| C-12 | DRAExtendedResourceが有効な場合DRAリソースが除外される | E-02 (350-388行目) | ○ |
| C-13 | 拒否理由としてOutOfcpu等が定義されている | E-02 (85-88行目) | ○ |
| C-14 | AdmissionFailureHandlerStubは拒否をそのまま通過させる | E-04 (37-39行目) | ○ |
| C-15 | maxRespBodyLengthは10KBに設定されている | E-03 (46行目) | ○ |
| C-16 | HTTP lifecycle hookでHTTPSフォールバックが実装されている | E-03 (151-169行目) | ○ |
| C-17 | Sleep lifecycle hookがFeatureGateで制御される | E-03 (112-125行目) | ○ |
| C-18 | Kubelet SyncLoopから全Admitハンドラーが順次呼ばれる | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-18: Kubelet本体（kubelet.go）からPodAdmitHandlersがどのように呼び出されるかの直接的なコード確認が本分析では行われていない
  - 候補：`pkg/kubelet/kubelet.go` / `pkg/kubelet/pod_workers.go` / `pkg/kubelet/kubelet_pods.go`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要ロジックはすべてソースコードから直接確認済み
- 1: 中リスク - Kubelet本体からの呼び出し経路は推測に基づく部分がある

## 6) レビュアーチェックリスト（最小）
- [ ] Kubelet SyncLoopからのPodAdmitHandlers呼び出しフローを確認
- [ ] features_linux.goのPodLevelResources判定ロジックの内容確認
- [ ] 静的PodのTaintチェック免除が期待通りか確認
